/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 *  MDIO Header file
 *
 */
#ifndef _DM388_MDIO_H_
#define _DM388_MDIO_H_
#ifdef __cplusplus
 extern "C" {
#endif

#include "DM388_EVM.h"

/* ------------------------------------------------------------------------ *
 *  MDIO Controller                                                         *
 * ------------------------------------------------------------------------ */
#define MDIO_BASE               0x4A100800
#define MDIO_CONTROL            *( volatile UINT32* )( MDIO_BASE + 0x04 )
#define MDIO_ALIVE              *( volatile UINT32* )( MDIO_BASE + 0x08 )
#define MDIO_LINK               *( volatile UINT32* )( MDIO_BASE + 0x0c )
#define MDIO_LINKINTRAW         *( volatile UINT32* )( MDIO_BASE + 0x10 )
#define MDIO_LINKINTMASKED      *( volatile UINT32* )( MDIO_BASE + 0x14 )
#define MDIO_USERINTRAW         *( volatile UINT32* )( MDIO_BASE + 0x20 )
#define MDIO_USERINTMASKED      *( volatile UINT32* )( MDIO_BASE + 0x24 )
#define MDIO_USERINTMASKSET     *( volatile UINT32* )( MDIO_BASE + 0x28 )
#define MDIO_USERINTMASKCLEAR   *( volatile UINT32* )( MDIO_BASE + 0x2c )
#define MDIO_USERACCESS0        *( volatile UINT32* )( MDIO_BASE + 0x80 )
#define MDIO_USERPHYSEL0        *( volatile UINT32* )( MDIO_BASE + 0x84 )
#define MDIO_USERACCESS1        *( volatile UINT32* )( MDIO_BASE + 0x88 )
#define MDIO_USERPHYSEL1        *( volatile UINT32* )( MDIO_BASE + 0x8c )

#define GMII_SEL				*( volatile UINT32* )(0x48140650)

#ifdef __cplusplus
} /* End of extern C */
#endif /* #ifdef __cplusplus */

#endif  /* End of _DM388_MDIO_H_ */
